﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
public partial class controls_LabResultInterpretation : System.Web.UI.UserControl
{
    private bool showBioMonFollowUp;


    public event EventHandler OnCancelClick;
    public event EventHandler OnSaveClick;
    public event EventHandler OnInterpretComplete;
    public event EventHandler OnPrintProviderLetter;
    public event EventHandler OnPrintPatientLetter;
    public event EventHandler OnAddPrintQueue;

    private Address Address = null;
    private PatientPCPInfo pcpInfo;
    private PatientVAMCInfo vamcInfo;

    private INTERPRETATION_LETTER IntLetter = null;
    private Address UseItToCompareAddress = null;
    private WorkflowManager caseManager = new WorkflowManager();

    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    public void UpdateInterpretationDetails(WKF_CASE wCase)
    {
        Address ProviderAddress = ProvAddress.GetAddress();
        Address PatntAddress = PatientAddress.GetAddress();
        WKF_CASE_ACTIVITY intActivity = wCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && e.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
        
        //Insert a new record in INTERPRETATION_LETTER
        if (intActivity.INTERPRETATION_LETTERs.Count() == 0)
        {
            IntLetter = new INTERPRETATION_LETTER();
            intActivity.INTERPRETATION_LETTERs.Add(IntLetter);
            IntLetter.SetAsInsertOnSubmit();
        }
        else
            IntLetter = intActivity.INTERPRETATION_LETTERs[0];

        IntLetter.WKF_CASE_ACTIVITY_ID = intActivity.WKF_CASE_ACTIVITY_ID;
        IntLetter.PROVIDER_NAME = ProviderAddress.Name;
        IntLetter.PROVIDER_ADDR1 = ProviderAddress.AddressPart1;
        IntLetter.PROVIDER_ADDR2 = ProviderAddress.AddressPart2;
        IntLetter.PROVIDER_ADDR3 = ProviderAddress.AddressPart3;
        IntLetter.PROVIDER_CITY = ProviderAddress.City;
        IntLetter.PROVIDER_STATE = ProviderAddress.State;
        IntLetter.PROVIDER_COUNTRY = ProviderAddress.Country;
        IntLetter.PROVIDER_PHONE = ProviderAddress.Phone;
        IntLetter.PROVIDER_POSTAL = ProviderAddress.Zip;
        IntLetter.PROVIDER_INSTITUTION_NAME = ProviderAddress.Facility; 

        IntLetter.WKF_CASE_ACTIVITY_ID = intActivity.WKF_CASE_ACTIVITY_ID;
        IntLetter.PATIENT_NAME = PatntAddress.Name;
        IntLetter.PATIENT_ADDR1 = PatntAddress.AddressPart1;
        IntLetter.PATIENT_ADDR2 = PatntAddress.AddressPart2;
        IntLetter.PATIENT_ADDR3 = PatntAddress.AddressPart3;
        IntLetter.PATIENT_CITY = PatntAddress.City;
        IntLetter.PATIENT_STATE = PatntAddress.State;
        IntLetter.PATIENT_COUNTRY = PatntAddress.Country;
        IntLetter.PATIENT_PHONE = PatntAddress.Phone;
        IntLetter.PATIENT_POSTAL = PatntAddress.Zip;

        IntLetter.PATIENT_INTERPRETATION_TEXT = TextBoxInterpretationNotesToPatient.Text;
        IntLetter.PROVIDER_INTERPRETATION_TEXT = TextBoxInterpretationNotesToProvider.Text;

        IntLetter.FROM_ADDRESS = TextBoxFrom.Text;
        IntLetter.Letter_SUBJECT = TextBoxSubject.Text;
        IntLetter.STD_SIGNING_CLINICIAN_ID = Helpers.ConvertStringToNullable<int>(DropDownListSigningClinician.SelectedValue);
        IntLetter.CCName = TextBoxCCName.Text;
        //IntLetter.ADDITIONAL_COMMENTS = TextBoxSigningCommentsProviderLetter.Text;

        IntLetter.PROVIDER_COMMENTS = TextBoxSigningCommentsProviderLetter.Text;
        IntLetter.PATIENT_COMMENT = TextBoxSigningCommentsPatientLetter.Text;
            
    }
    
    public void UpdateProviderAddress(REFERRAL referral)
    {
        Address ProviderAddress = ProvAddress.GetAddress();

        WKF_CASE_ACTIVITY intActivity = referral.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && e.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            //Got it from interpretation letters table
            IntLetter = intActivity.INTERPRETATION_LETTERs[0];
            UseItToCompareAddress = GetLetterProviderAddress(IntLetter);
        }
        else  //Got it from Referral table
            UseItToCompareAddress = GetReferralProviderAddress(referral);
                //new Address { AddressPart1 = Ref.PROVIDER_ADDRESS_LINE1, AddressPart2 = Ref.PROVIDER_ADDRESS_LINE2, AddressPart3 = Ref.PROVIDER_ADDRESS_LINE3, City = Ref.PROVIDER_CITY, Phone = Ref.PROVIDER_PHONE, Zip = Ref.PROVIDER_POSTAL_CODE, State = Ref.PROVIDER_STATE, Country = Ref.PROVIDER_COUNTRY, Name = Ref.PROVIDER_NAME };

        //Check if the pre-populated provider address has been changed.
        //TODO - If Address line 1 exists in activity, use it to compare. Elase use referral
        if (UseItToCompareAddress.AddressPart1 != ProviderAddress.AddressPart1 || UseItToCompareAddress.AddressPart2 != ProviderAddress.AddressPart2 ||
            UseItToCompareAddress.AddressPart3 != ProviderAddress.AddressPart3 || UseItToCompareAddress.City != ProviderAddress.City ||
            UseItToCompareAddress.Country != ProviderAddress.Country || UseItToCompareAddress.State != ProviderAddress.State ||
            UseItToCompareAddress.Name != ProviderAddress.Name || UseItToCompareAddress.Phone!= ProviderAddress.Phone || UseItToCompareAddress.Zip != ProviderAddress.Zip)
        {
            //Insert a new record in INTERPRETATION_LETTER
            if (intActivity.INTERPRETATION_LETTERs.Count() == 0)
            {
                IntLetter = new INTERPRETATION_LETTER();
                intActivity.INTERPRETATION_LETTERs.Add(IntLetter);
                IntLetter.SetAsInsertOnSubmit();
            }
            else
                IntLetter = intActivity.INTERPRETATION_LETTERs[0];

            IntLetter.WKF_CASE_ACTIVITY_ID = intActivity.WKF_CASE_ACTIVITY_ID;
            IntLetter.PROVIDER_NAME = ProviderAddress.Name;
            IntLetter.PROVIDER_ADDR1 = ProviderAddress.AddressPart1;
            IntLetter.PROVIDER_ADDR2 = ProviderAddress.AddressPart2;
            IntLetter.PROVIDER_ADDR3 = ProviderAddress.AddressPart3;
            IntLetter.PROVIDER_CITY = ProviderAddress.City;
            IntLetter.PROVIDER_STATE = ProviderAddress.State;
            IntLetter.PROVIDER_COUNTRY = ProviderAddress.Country;
            IntLetter.PROVIDER_PHONE = ProviderAddress.Phone;
            IntLetter.PROVIDER_POSTAL = ProviderAddress.Zip;

        }
    }


    public bool ShowBioMonitoringFollowUpSection
    {
        set
        {
            PanelBioFollowUp.Visible = value;
            
            showBioMonFollowUp = value;
        }
    }


    public bool ShowFacilityBoxAndPCPVAMCPanels
    {
        set
        {
            ProvAddress.ShowFacilityBoxAndPCPVAMCPanels = value;
            //labelFacilityName.Visible = txtFacilityName.Visible = value;
            //PCPInfoPanel.Visible = VAMCInfoPanel.Visible = value;
            PatientAddress.ShowFacilityBoxAndPCPVAMCPanels = false;
        }

    }

    public bool ShowPrimaryAltAddressPanels
    {

        set
        {
            ProvAddress.ShowPrimaryAlternateAddressPanels = value;
            //labelFacilityName.Visible = txtFacilityName.Visible = value;
            //PCPInfoPanel.Visible = VAMCInfoPanel.Visible = value;
            PatientAddress.ShowFacilityBoxAndPCPVAMCPanels = false;
        }

    }

    private Address GetLetterPatientAddress(INTERPRETATION_LETTER letter)
    {
        return new Address { AddressPart1 = letter.PATIENT_ADDR1, AddressPart2 = letter.PATIENT_ADDR2, AddressPart3 = letter.PATIENT_ADDR3, City = letter.PATIENT_CITY, Phone = letter.PATIENT_PHONE, Zip = letter.PATIENT_POSTAL, Country = letter.PATIENT_COUNTRY, State = letter.PATIENT_STATE, Name = letter.PATIENT_NAME };
    }

    private Address GetLetterProviderAddress(INTERPRETATION_LETTER letter)
    {
        return new Address { AddressPart1 = letter.PROVIDER_ADDR1, AddressPart2 = letter.PROVIDER_ADDR2, AddressPart3 = letter.PROVIDER_ADDR3, Facility = letter.PROVIDER_INSTITUTION_NAME,  City = letter.PROVIDER_CITY, Phone = letter.PROVIDER_PHONE, Zip = letter.PROVIDER_POSTAL, State = letter.PROVIDER_STATE, Country = letter.PROVIDER_COUNTRY, Name = letter.PROVIDER_NAME };
    }

    private Address GetReferralProviderAddress(REFERRAL referral)
    {
        
        return new Address { AddressPart1 = referral.PROVIDER_ADDRESS_LINE1, AddressPart2 = referral.PROVIDER_ADDRESS_LINE2, AddressPart3 = referral.PROVIDER_ADDRESS_LINE3, City = referral.PROVIDER_CITY, Phone = referral.PROVIDER_PHONE, Zip = referral.PROVIDER_POSTAL_CODE, State = referral.PROVIDER_STATE, Country = referral.PROVIDER_COUNTRY, Name = referral.PROVIDER_NAME };
        
    }

    public void UpdateAddresses(WKF_CASE_ACTIVITY activity)
    {
        //GetUpdatedPatientAddress(activity.WKF_CASE);
        UpdateProviderAddress(activity.WKF_CASE.REFERRAL);
    }

    public void FillProviderAddress(Address address)
    {
        ProvAddress.PopulateAddress(address);
    }

    public void FillPatientAddress(Address address)
    {
        PatientAddress.PopulateAddress(address);
    }

    public void FillPatientPCPInfo(PatientPCPInfo pcpInfo)
    {
        ProvAddress.PopulatePCPInfo(pcpInfo);
    }

    public void FillPatientVAMCInfo(PatientVAMCInfo vamcInfo)
    {
        ProvAddress.PopulateVAMCInfo(vamcInfo);
    }

    public void FillPrimaryAddress(Address address)
    {
        PatientAddress.PopulatePrimaryAddressInfo(address); 

    }

    public void FillSecondaryAddress(Address address)
    {
        PatientAddress.PopulateSecondaryAddressInfo(address);

    }

    public void PopulateBioFollowUp(WKF_CASE wCase)
    {
        WKF_CASE_ACTIVITY activity = wCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && e.ARCHIVED_FLAG == false).FirstOrDefault();

        if (activity != null)
        {
            if (activity.FOLLOWUP_REQUIRED_FLAG.HasValue)
            {
                if (activity.STD_WKFACTIVITYST.CODE != "INTERPRETED")
                {
                    rbNeedBiomonitoringFollowUp.SelectedIndex = rbNeedBiomonitoringFollowUp.Items.IndexOf(rbNeedBiomonitoringFollowUp.Items.FindByValue(Convert.ToInt32(activity.FOLLOWUP_REQUIRED_FLAG.Value).ToString()));
                }
                else
                {
                    if (activity.FOLLOWUP_PLAN_DATE.HasValue)
                    {
                        rbNeedBiomonitoringFollowUp.SelectedValue = "1";

                    }
                    else
                    {
                        rbNeedBiomonitoringFollowUp.SelectedValue = "0";
                    }
                }
            }

           
            DateTime bioMonDueDate = DateTime.Today.AddYears(5);
            DateTime reminderDate = new DateTime(bioMonDueDate.AddMonths(-1).Year, bioMonDueDate.AddMonths(-1).Month, 1);

            if (activity.FOLLOWUP_PLAN_DATE.HasValue)
            {
                //if the activity has a value saved display it
                txtBioMonDueDate.Text = activity.FOLLOWUP_PLAN_DATE.Value.ToString("d");
            }
            else
            {
                //if the activity status is not "Intrepreted" then set a default value
                //if (activity.STD_WKFACTIVITYST.CODE != "INTERPRETED")
                //{
                txtBioMonDueDate.Text = bioMonDueDate.ToString("d");
                //}
                //else
                //{
                //    //else display empty string since the status is intrepreted, the form is read only and a date has not been saved to the database
                //    txtBioMonDueDate.Text = "";
                //}
            }

            if (activity.FOLLOWUP_REMINDER_DATE.HasValue)
            {
                //if the activity has a value saved display it
                txtReminderDate.Text = activity.FOLLOWUP_REMINDER_DATE.Value.ToString("d");
            }
            else
            {
                //if the activity status is not "Intrepreted" then set a default value
                //if (activity.STD_WKFACTIVITYST.CODE != "INTERPRETED")
                //{
                txtReminderDate.Text = reminderDate.ToString("d");
                //}
                //else
                //{
                //    //else display empty string since the status is intrepreted, the form is read only and a date has not been saved to the database
                //    txtReminderDate.Text = "";
                //}
            }
            

            //follow-up is set 
            if (activity.FOLLOWUP_WKF_CASE_ID.HasValue)
            {
                WKF_CASE followUp = caseManager.GetWorkFlowCase(activity.FOLLOWUP_WKF_CASE_ID.Value);

                LabelBioFollowUp.Text = "The Follow Up Biomonitoring was created on " + followUp.CREATED.ToString("d") + ", Workflow ID ";

                LinkBioFollowUp.Visible = true;
                LinkBioFollowUp.Text = followUp.WKF_CASE_ID.ToString();
                LinkBioFollowUp.NavigateUrl = String.Format("~/PatientWorkflows.aspx?patientId={0}", followUp.REFERRAL.PATIENT.PATIENT_ID);

            }
            else if (activity.FOLLOWUP_DECLINED_DATE.HasValue)
            {
                LabelBioFollowUp.Text = "The Follow Up Biomonitoring has been declined on " + activity.FOLLOWUP_DECLINED_DATE.Value.ToString("d");

                LinkBioFollowUp.Visible = false;

            }
            else
            {
                LabelBioFollowUp.Visible = false;
                LinkBioFollowUp.Visible = false;

            }

        }
    }
    public void SaveBioFollowUp(WKF_CASE wCase)
    {
        WKF_CASE_ACTIVITY activity = wCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && e.ARCHIVED_FLAG == false).FirstOrDefault();

        if (activity != null)
        {
            activity.FOLLOWUP_REQUIRED_FLAG = (int.Parse(rbNeedBiomonitoringFollowUp.SelectedValue) == 1);

            activity.FOLLOWUP_PLAN_DATE  = Helpers.ConvertStringToNullable<DateTime>(txtBioMonDueDate.Text.Trim());

            activity.FOLLOWUP_REMINDER_DATE = Helpers.ConvertStringToNullable<DateTime>(txtReminderDate.Text.Trim());


        }
    }
    public void PopulatePatientProviderDetails(WKF_CASE wcase, string LetterType)
    {
        //Populate patient address
        WKF_CASE_ACTIVITY intActivity = wcase.WKF_CASE_ACTIVITies.Where(e=>e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) 
            && e.ARCHIVED_FLAG == false).FirstOrDefault();
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0 && intActivity.INTERPRETATION_LETTERs[0].PATIENT_ADDR1 != null)
            //Look in interpretation letters table
            Address = GetLetterPatientAddress(intActivity.INTERPRETATION_LETTERs[0]);
        else if (wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs.Count() > 0)
        {


            //Look in demographics table if city is populated, otherwise use primary address
            if (!String.IsNullOrEmpty(wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs.First().CITY))
            {

                REGISTRY_DEMOGRAPHIC Demog = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0];
                Address = new Address { AddressPart1 = Demog.ADDRESS_LINE1, AddressPart2 = Demog.ADDRESS_LINE2, AddressPart3 = Demog.ADDRESS_LINE3, City = Demog.CITY, Phone = Demog.WORK_PHONE, Zip = Demog.POSTAL_CODE, Country = Demog.COUNTRY, State = Demog.STATE, Name = wcase.REFERRAL.PATIENT.FullName };

            }
            else
            {
                PATIENT Patnt = wcase.REFERRAL.PATIENT;
                Address = new Address { AddressPart1 = Patnt.ADDRESS_LINE1, AddressPart2 = Patnt.ADDRESS_LINE2, AddressPart3 = Patnt.ADDRESS_LINE3, City = Patnt.CITY, Phone = Patnt.WORK_PHONE, Zip = Patnt.POSTAL_CODE, State = Patnt.STATE, Country = Patnt.COUNTRY, Name = Patnt.FullName };
 
            }
               
        }
        else //Pre-populate patient original address
        {
            PATIENT Patnt = wcase.REFERRAL.PATIENT;
            Address = new Address { AddressPart1 = Patnt.ADDRESS_LINE1, AddressPart2 = Patnt.ADDRESS_LINE2, AddressPart3 = Patnt.ADDRESS_LINE3, City = Patnt.CITY, Phone = Patnt.WORK_PHONE, Zip = Patnt.POSTAL_CODE, State = Patnt.STATE, Country = Patnt.COUNTRY, Name=Patnt.FullName };


            
        }

        
        FillPatientAddress(Address);

        var primary = new Address { AddressPart1 = wcase.REFERRAL.PATIENT.ADDRESS_LINE1, AddressPart2 = wcase.REFERRAL.PATIENT.ADDRESS_LINE2, AddressPart3 = wcase.REFERRAL.PATIENT.ADDRESS_LINE3, City = wcase.REFERRAL.PATIENT.CITY, Phone = wcase.REFERRAL.PATIENT.WORK_PHONE, Zip = wcase.REFERRAL.PATIENT.POSTAL_CODE, State = wcase.REFERRAL.PATIENT.STATE, Country = wcase.REFERRAL.PATIENT.COUNTRY, Name = wcase.REFERRAL.PATIENT.FullName };

        FillPrimaryAddress(primary);

        var secondary = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs.Count() > 0 ? Address = new Address { AddressPart1 = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].ADDRESS_LINE1, AddressPart2 = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].ADDRESS_LINE2, AddressPart3 = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].ADDRESS_LINE3, City = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].CITY, Phone = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].WORK_PHONE, Zip = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].POSTAL_CODE, Country = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].COUNTRY, State = wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs[0].STATE, Name = wcase.REFERRAL.PATIENT.FullName }: primary;

        FillSecondaryAddress(secondary);

        if (wcase.REFERRAL.PATIENT.REGISTRY_DEMOGRAPHICs.Count() == 0)
        {
            var primPanel = PatientAddress.FindControl("PrimaryAddressPanel") as Panel;

            var secPanel = PatientAddress.FindControl("AlternateAddressPanel") as Panel;

            if (primPanel != null && secPanel != null)
            {
                primPanel.Visible = secPanel.Visible = false; 
            }          

        }
        pcpInfo = new PatientPCPInfo
        {
            Address1 = wcase.REFERRAL.PROVIDER_ADDRESS_LINE1,
            Address2 = wcase.REFERRAL.PROVIDER_ADDRESS_LINE2,
            Address3 = wcase.REFERRAL.PROVIDER_ADDRESS_LINE3,
            City = wcase.REFERRAL.PROVIDER_CITY,
            Name = wcase.REFERRAL.PROVIDER_NAME,
            Country = wcase.REFERRAL.PROVIDER_COUNTRY,
            Phone = wcase.REFERRAL.PROVIDER_PHONE, 
            State = wcase.REFERRAL.PROVIDER_STATE,
            Zip = wcase.REFERRAL.PROVIDER_POSTAL_CODE
            
        };



        CityStateManager addressManager = new CityStateManager();

        vamcInfo = new PatientVAMCInfo();
        vamcInfo.Name = wcase.REFERRAL.VAMC_CONTACT_NAME;
        vamcInfo.Phone = wcase.REFERRAL.VAMC_CONTACT_PHONE;
        vamcInfo.Facility = wcase.REFERRAL.STD_INSTITUTION == null ? String.Empty : wcase.REFERRAL.STD_INSTITUTION.NAME;

        if (!string.IsNullOrEmpty(wcase.REFERRAL.ADDRESS_LINE1))
        {
            vamcInfo.Address1 =  wcase.REFERRAL.ADDRESS_LINE1;
            vamcInfo.Address2 = wcase.REFERRAL.ADDRESS_LINE2;
            vamcInfo.Address3 = wcase.REFERRAL.ADDRESS_LINE3;
            vamcInfo.City = wcase.REFERRAL.CITY;
            vamcInfo.Country = wcase.REFERRAL.COUNTRY;
            vamcInfo.State = wcase.REFERRAL.STATE;
            vamcInfo.Zip = wcase.REFERRAL.POSTAL_CODE;
        }
        else if (wcase.REFERRAL.STD_INSTITUTION != null)
        {
            if (!string.IsNullOrEmpty(wcase.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1))
            {
                 vamcInfo.Address1 = wcase.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1;
                 vamcInfo.Address2 = wcase.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE2;
                 vamcInfo.Address3 = wcase.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE3;
                 vamcInfo.City = wcase.REFERRAL.STD_INSTITUTION.MAILINGCITY;
                 vamcInfo.Country = wcase.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID.HasValue? addressManager.GetCountryByID((int)wcase.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID): string.Empty;
                 vamcInfo.State = wcase.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.HasValue? addressManager.GetStateByID((int) wcase.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID): string.Empty;
                 vamcInfo.Zip = wcase.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE;
            }
            else
            {
                 vamcInfo.Address1 = wcase.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE1;
                 vamcInfo.Address2 = wcase.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE2;
                 vamcInfo.Address3 = wcase.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE3;
                 vamcInfo.City = wcase.REFERRAL.STD_INSTITUTION.STREETCITY;
                 vamcInfo.Country = wcase.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID.HasValue? addressManager.GetCountryByID((int)wcase.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID): string.Empty;
                 vamcInfo.State = wcase.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.HasValue? addressManager.GetStateByID((int) wcase.REFERRAL.STD_INSTITUTION.STREETSTATE_ID): string.Empty;
                 vamcInfo.Zip = wcase.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE;
            }
        }

        FillPatientPCPInfo(pcpInfo);

        FillPatientVAMCInfo(vamcInfo);
        //Populate provider updated address
        //Updated address available, populate it
         
            
       if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0 && intActivity.INTERPRETATION_LETTERs[0].PROVIDER_ADDR1 != null)
            Address = GetLetterProviderAddress(intActivity.INTERPRETATION_LETTERs[0]);
        else //Pre-populate original address from REFERRAL
        {
            Address = GetReferralProviderAddress(wcase.REFERRAL);
        }
        FillProviderAddress(Address);
        
        //Set visibility of controls based on workflow type
        switch (LetterType)
        {
            case "Bio":
                //FROM
                TextBoxFrom.Visible = true;
                LabelForTextBoxFrom.Visible = true;
                //SUBJECT
                TextBoxSubject.Visible = true;
                LabelForTextBoxSubject.Visible = true;
                //Signing Clinician
                DropDownListSigningClinician.Visible = true;
                LabelForDropDownListSigningClinician.Visible = true;
                //CC
                TextBoxCCName.Visible = true;
                LabelForTextBoxCCName.Visible = true;
                //Signing Comments Provider
                TextBoxSigningCommentsProviderLetter.Visible = true;
                LabelForTextBoxSigningCommentsProviderLetter.Visible = true;
                //Signing Comments Patient
                TextBoxSigningCommentsPatientLetter.Visible = true;
                LabelforTextBoxSigningCommentsPatientLetter.Visible = true;
                break;
            case "Fragment":
                //FROM
                TextBoxFrom.Visible = true;
                LabelForTextBoxFrom.Visible = true;
                //SUBJECT
                TextBoxSubject.Visible = true;
                LabelForTextBoxSubject.Visible = true;
                //Signing Clinician
                DropDownListSigningClinician.Visible = true;
                LabelForDropDownListSigningClinician.Visible = true;
                //CC
                TextBoxCCName.Visible = true;
                LabelForTextBoxCCName.Visible = true;
                //Signing Comments Provider
                TextBoxSigningCommentsProviderLetter.Visible = true;
                LabelForTextBoxSigningCommentsProviderLetter.Visible = true;
                //Signing Comments Patient
                TextBoxSigningCommentsPatientLetter.Visible = true;
                LabelforTextBoxSigningCommentsPatientLetter.Visible = true;
                break;

        }


        if (intActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.New)
        {
            btnPrintPatntLttr.Enabled = btnPrintPrvdrLttr.Enabled = btnAddPrintQueue.Enabled = false;

        }
        else
        {

            btnPrintPatntLttr.Enabled = btnPrintPrvdrLttr.Enabled = btnAddPrintQueue.Enabled = true;
        }

        //Bind interpretation letter items
        if (intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            //interpretation notes to patient.
            TextBoxInterpretationNotesToPatient.Text = intActivity.INTERPRETATION_LETTERs[0].PATIENT_INTERPRETATION_TEXT;

            //interpretation notes to provider.
            TextBoxInterpretationNotesToProvider.Text = intActivity.INTERPRETATION_LETTERs[0].PROVIDER_INTERPRETATION_TEXT;


            //FROM
            TextBoxFrom.Text = intActivity.INTERPRETATION_LETTERs[0].FROM_ADDRESS;

            //SUBJECT
            TextBoxSubject.Text = intActivity.INTERPRETATION_LETTERs[0].Letter_SUBJECT;

            //Signing Clinician
            if (intActivity.INTERPRETATION_LETTERs[0].STD_SIGNING_CLINICIAN_ID.HasValue)
            {
                DropDownListSigningClinician.SelectedValue = intActivity.INTERPRETATION_LETTERs[0].STD_SIGNING_CLINICIAN_ID.Value.ToString();
            }

            //CC
            TextBoxCCName.Text = intActivity.INTERPRETATION_LETTERs[0].CCName;

            //Signing Comments
            //TextBoxSigningCommentsProviderLetter.Text = intActivity.INTERPRETATION_LETTERs[0].ADDITIONAL_COMMENTS;

            //Signing Comments Provider
            TextBoxSigningCommentsProviderLetter.Text = intActivity.INTERPRETATION_LETTERs[0].PROVIDER_COMMENTS;

            //Signing Comments Patient
            TextBoxSigningCommentsPatientLetter.Text = intActivity.INTERPRETATION_LETTERs[0].PATIENT_COMMENT;

            
        }
        else
        {
            //interpretation letter does not exist and the page is opening a "new" letter so populate with default values

            //interpretation notes to patient
            TextBoxInterpretationNotesToPatient.Text = "";

            //interpretation notes to provider
            TextBoxInterpretationNotesToProvider.Text = "";

            //FROM
            TextBoxFrom.Text = "Medical Director, Toxic Embedded Fragment Surveillance Center (512/11DU) Baltimore VA Medical Center";
            //Signing Clinician
            DropDownListSigningClinician.SelectedIndex = 1;
            //CC
            TextBoxCCName.Text = "";
            //Signing Comments Provider
            TextBoxSigningCommentsProviderLetter.Text = "A copy of the enclosed letter addressed to the patient has been mailed directly to the patient. If you have any questions, please do not hesitate to call me at (410) 605-7373.";
            //Signing Comments Patient
            TextBoxSigningCommentsPatientLetter.Text = "We are also sending your results to your VA healthcare provider. Please contact your VA healthcare provider if you have questions and to discuss the need for follow-up.";
                            
            
            switch (LetterType)
            {
                case "Bio":
                    //SUBJECT
                    TextBoxSubject.Text = "Interpretation Urine Biomonitoring Results for";
                    break;
                case "Fragment":
                    //SUBJECT
                    TextBoxSubject.Text = "Interpretation Fragment Analysis Results for";
                    break;
                
            }
            
        }

        //Configure buttons

        var test1 = intActivity.STD_WKFACTIVITYSTS_ID;
        var test2 = intActivity.STD_WKFACTIVITYST.CODE;
        if (intActivity.STD_WKFACTIVITYST.CODE == null)
        {
            return;
        }

        switch (intActivity.STD_WKFACTIVITYST.CODE)
        {
            case "NEW":

                btnPrintPatntLttr.Text = " Preview Patient Letter ";
                btnPrintPrvdrLttr.Text = "Preview Provider Letter";
                btnSave.Enabled = true;
                btnInterpretComplete.Enabled = true;
                //btnAddPrintQueue.Enabled = false;
                HiddenFieldCompletedInterpretation.Value = "0";
                break;

            case "IN-PROCESS":

                btnPrintPatntLttr.Text = " Preview Patient Letter ";
                btnPrintPrvdrLttr.Text = "Preview Provider Letter";
                btnSave.Enabled = true;
                btnInterpretComplete.Enabled= true;
                //btnAddPrintQueue.Enabled = true;
                HiddenFieldCompletedInterpretation.Value = "0";
                break;

            case "INTERPRETED":
                
                btnSave.Enabled = _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR);   
               
                btnInterpretComplete.Enabled = false;
                //btnAddPrintQueue.Enabled = true;

                //setup onclick attribute for print buttons when printing is done
                btnPrintPatntLttr.Attributes.Remove("OnClientClick");
                btnPrintPrvdrLttr.Attributes.Remove("OnClientClick");

                HiddenFieldCompletedInterpretation.Value = "1";

                break;

            default:
                break;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BioFollowupDueDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();
            //ReminderDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();
            ReminderFutureDateValidator.ValueToCompare = DateTime.Today.ToShortDateString(); 
        }

        //Follow Up Biomonitoring Due Date and Reminder Date are not required if 
        //Need Biomonitoring Follow Up is set to no (rbNeedBiomonitoringFollowUp)
        if (rbNeedBiomonitoringFollowUp.SelectedValue == "0")
        {
            RequiredValidatorDueDate.Enabled = false;
            RequiredFieldValidatorReminderDate.Enabled = false;
        }
        else
        {
            RequiredValidatorDueDate.Enabled = true;
            RequiredFieldValidatorReminderDate.Enabled = true;
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {        
        if (this.OnSaveClick != null)
            this.OnSaveClick(this, new EventArgs());
    }
    protected void btnInterpretComplete_Click(object sender, EventArgs e)
    {
        if (this.OnInterpretComplete != null)
            this.OnInterpretComplete(this, new EventArgs());
    }
    protected void btnPrintPrvdrLttr_Click(object sender, EventArgs e)
    {
        if (this.OnPrintProviderLetter != null)
            this.OnPrintProviderLetter(this, new EventArgs());
    }
    protected void btnAddPrintQueue_Click(object sender, EventArgs e)
    {
        if (this.OnAddPrintQueue != null)
            this.OnAddPrintQueue(this, new EventArgs());
    }
    protected void btnPrintPatntLttr_Click(object sender, EventArgs e)
    {
        if (this.OnPrintPatientLetter != null)
            this.OnPrintPatientLetter(this, new EventArgs());
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        if (this.OnCancelClick != null)
            this.OnCancelClick(this, new EventArgs());
    }

}
